<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:ns1="http://www.sec.gov/edgar/common" xmlns:n1="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/statecodes" xmlns:p="http://www.sec.gov/edgar/ta/tawfiler">
	
	<xsl:import href="util.xsl" />

	<xsl:output method="html" indent="no" encoding="iso-8859-1"
		doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" />
	
	<xsl:template match="/">
		<html>
			<head>
				<link rel="stylesheet" type="text/css" href="css/SDR_print.css" />
			</head>

			<body lang="en-US" text="#000000" bgcolor="#ffffff">
				<div style="display:none">
					schemaVersion:
					<xsl:value-of select="string(p:edgarSubmission/p:schemaVersion)" />
				</div>
				<xsl:call-template name="header" />
				<xsl:apply-templates select="p:edgarSubmission/p:headerData" />
				<xsl:apply-templates select="p:edgarSubmission"/>
			</body>
		</html>
	</xsl:template>
	<!-- Header Template START -->
	<xsl:template name="header">
			<div class="contentwrapper">			
						<table role="presentation" id="header">
								<tr>
								   <td class="title">Form TA-W Filer Information</td>
									<td rowspan="2" class="center">			
											<br/>
											UNITED STATES
											<br/>
											SECURITIES AND EXCHANGE COMMISSION
											<br/>
											Washington, D.C. 20549
											<br/><br/>
											FORM TA-W											
									</td>
									<td class="title">OMB APPROVAL</td>
								</tr>
								<tr>
								<td class="side" style="text-align: center;">
									<p>
										<br />
										FORM TA-W
										<br />
									</p>
								</td>
								<td
									width="25%"
									class="side">
							
									<p>OMB Number:&#160;&#160; 3235-0151</p>
									<hr></hr>
									<p>Estimated average burden hours per response: 0.5</p>
								</td>
							</tr>
							</table>
					</div>		
				</xsl:template>	
	<!-- Header Template END -->
	
	
	<!-- 1-Z: Filer Information Template START -->
	<xsl:template name="headerData" match="p:edgarSubmission/p:headerData">
		<div id="info">
			<div class="contentwrapper">
				<div class="content">							
					<h1>TA-W : Filer Information</h1>		
					<table role="presentation">
						<tr>
							<td class="label"><b>1(a).</b> Filer CIK:</td>
							<td>
								<div class="fakeBox2">
								<xsl:call-template name="CIKLink" >
									<xsl:with-param name="aCIK" select="p:filerInfo/p:filer/p:filerCredentials/p:cik"></xsl:with-param>
									<xsl:with-param name="label" select="p:filerInfo/p:filer/p:filerCredentials/p:cik"></xsl:with-param>									
								</xsl:call-template>
								</div>									
							</td>
						</tr>
						<tr>
							<td class="label"><b>1(b).</b> Filer CCC:</td>
							<td>
								<div class="fakeBox2">
								**********
								</div>
							</td>
						</tr>
						<tr>
							<td class="label"><b>1(c).</b> Is this a LIVE or TEST submission?</td>
							<td>							
								<xsl:choose>
									<xsl:when test="p:filerInfo/p:liveTestFlag = 'LIVE'">
										<img src="Images/radio-checked.jpg" alt="radio button checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								&#160;LIVE
								<xsl:choose>
									<xsl:when test="p:filerInfo/p:liveTestFlag = 'TEST'">
										<img src="Images/radio-checked.jpg" alt="radio button checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								&#160;TEST							
							</td>
						</tr>
						<tr>
							<td class="label"><b>1(d).</b> Would you like a Return Copy?</td>
							<td>
								<xsl:choose>
									<xsl:when test="p:filerInfo/p:flags/p:returnCopyFlag = 'true'">
										<img src="Images/box-checked.jpg" alt="Checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>	
					</table>
					<p></p>
						
			      <h3>Submission Contact Information</h3>
			      <p></p>
					The registrant may provide a single e-mail address for contact purposes.
					<p></p>
					<table role="presentation">
						<tr>
							<td class="label"><b>1(e)(i).</b> Contact Name:</td>
							<td>
								<div class="fakeBox3">
									<xsl:value-of select="p:filerInfo/p:contact/p:contactName" />
								</div>
							</td>
						</tr>
						<tr>
							<td class="label"><b>1(e)(ii).</b> Contact Phone Number:</td>
							<td>
								<div class="fakeBox2">
									<xsl:value-of select="p:filerInfo/p:contact/p:contactPhoneNumber" />
								</div>
							</td>
						</tr>

						<tr>
							<td class="label"><b>1(e)(iii).</b> Contact E-Mail Address:</td>
							<td>
								<div class="fakeBox">
									<xsl:value-of select="p:filerInfo/p:contact/p:contactEmailAddress" />
								</div>
							</td>
						</tr>
					</table>
					<p></p>
					<h3>Notification Information</h3>
					<p></p>
						Notification will automatically be sent to the Login CIK, Submission Contact and Primary Registrants.
					The registrant may provide additional e-mail addresses for those persons the filer would like to receive notification e-mails regarding the filing. 				
					<xsl:for-each
						select="p:filerInfo/p:notifications/p:notificationEmailAddress">
						<table role="presentation" >
							<tr>
								<td class="label"><b>1(f).</b> Notification E-mail Address:</td>
								<td>
									<div class="fakeBox">
										<xsl:value-of select="." />
										<span>
											<xsl:text>&#160;</xsl:text>
										</span>
									</div>
								</td>
							</tr>
						</table>
					</xsl:for-each>
					</div>	
				</div>
			</div>	
	</xsl:template>	
	<!-- Form Data Template END -->
		
	<xsl:template name="formData" match="p:edgarSubmission">
		<div class="content">
			<h1>TA-W: Registration Information</h1>
			<div class="form1">
				<xsl:call-template name="Item1">
				</xsl:call-template>
			</div>

			<h1>TA-W: Withdrawal Information</h1>
			<div class="form1">
				<xsl:call-template name="Item2">
				</xsl:call-template>
			</div>

			<h1>TA-W: Legal Action Information </h1>
			<div class="form1">
				<xsl:call-template name="Item3">
				</xsl:call-template>
			</div>

			<h1>TA-W: Document Retention Information </h1>
			<div class="form1">
				<xsl:call-template name="Item4">
				</xsl:call-template>
			</div>			

			<h1>TA-W: Signature </h1>
			<div class="form1">
				<xsl:call-template name="Item5">
				</xsl:call-template>
			</div>				
		</div>
	</xsl:template>
	<!-- Form Data Template END -->

	<!-- Documents Template START (intent not to display -->
	<xsl:template name="documents"
		match="p:edgarSubmission/p:documents">
		<div style="display:none">
					<xsl:call-template name="Documents" />
		</div>
	</xsl:template>	
	<!-- Documents Template END -->	
	
	
	<!-- items START -->	
	<xsl:include href="TA-W_item1.xsl" />
	<xsl:include href="TA-W_item2.xsl" />	
	<xsl:include href="TA-W_item3.xsl" />
	<xsl:include href="TA-W_item4.xsl" />	
	<xsl:include href="TA-W_item5.xsl" />
	<xsl:include href="TA-W_documents.xsl" />	
	<!-- items END -->
	
	<xsl:include href="SDR_State_Codes.xsl" />
</xsl:stylesheet>